package gov.va.med.mhv.usermgmt.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.util.TimestampUtils;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01AcknowledgementDetail;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document.MCCIIN000002UV01;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.service.MHVAbstractService;
import gov.va.med.mhv.usermgmt.bizobj.BusinessObjectFactory;
import gov.va.med.mhv.usermgmt.bizobj.InPersonAuthenticationBO;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.enumeration.PatientCorrelationStatus;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationServiceResponse;
import gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.service.ServiceFactory;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.service.handler.MviInvocationUtilHandler;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.PatientRegistryChange;
import gov.va.med.mhv.usermgmt.transfer.PatientSynchronization;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.Auditor;
import gov.va.med.mhv.usermgmt.util.InPersonAuthenticationStatusUtils;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVICorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIPatientSearchRequest;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;
import gov.va.med.mhv.usermgmt.util.mvi.MviRequestTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviResponseTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviUtil;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.BooleanServiceResponse;
import org.tigris.atlas.service.VoidServiceResponse;

/**
 * Service implementation class for the MviAsyncIntegration service
 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService
 */
public class MviAsyncIntegrationServiceImpl extends MHVAbstractService implements MviAsyncIntegrationService {

	private static final Log LOG = LogFactory.getLog(MviAsyncIntegrationServiceImpl.class);
	
	
	
	/**
	 * Execute the AddPersonForCorrelation service
	 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService#AddPersonForCorrelation()
	 */
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService#addPersonForCorrelation(java.lang.String, java.lang.String, java.lang.String)
	 */
	public BooleanServiceResponse addPersonForCorrelation(Patient patient, UserProfile userProfile, Boolean isRegistration) {
		BooleanServiceResponse response = new BooleanServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if(patient == null || patient.getIcn() == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					LOG.error("ICN is Empty: " +patient.getIcn());
			}
			return response;
		}
		//patient.setCorrelationStatus(PatientCorrelationStatusUtils.PENDING_CORRELATION);
		//patient.setCorrelateRequestDate(Calendar.getInstance().getTime());
		patient.setCorrelateRequestDateTime(new Timestamp(System.currentTimeMillis()));
		//PatientServiceResponse psr = ServiceFactory.createEntityMaintenanceService().save(patient);

		Object correlationReqXML = CreateMVICorrelationRequest.createCorrelationXMLRequest(userProfile,patient); 
		//MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);

		if(searchObj ==null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			response.setBoolean(false);
		}
		else {
			searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			//Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];  
			
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.CORRELATED);
				if ( (patient.getPatientSynchronizations() != null) && !patient.getPatientSynchronizations().isEmpty() ) {
					Set<PatientSynchronization> patientSyncSet = patient.getPatientSynchronizations();
					for (Iterator<PatientSynchronization> it = patientSyncSet.iterator(); it.hasNext(); ) {
						PatientSynchronization patientSync = it.next();
						patient.removePatientSynchronization(patientSync);
					}
				}
				//Admin Portal_CodeCR1747 - Changed from SYSTEM to System
				patient.setCorrelatedBy("System");
				//ServiceFactory.createEntityMaintenanceService().save(patient);
				/*
				if(isRegistration != null && isRegistration)
					Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD, ActivityTypeEnumeration.REGISTRATION);
				else if(isRegistration != null && !isRegistration)
					Auditor.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD);
				else if(isRegistration == null)
					Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SELF,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD, ActivityTypeEnumeration.PROFILES);
				*/
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				response.setBoolean(true);

			}
			else {
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.FAILED_CORRELATION);
				//ServiceFactory.createEntityMaintenanceService().save(patient);
			}

		}
		ServiceFactory.createEntityMaintenanceService().save(patient);
		return response;
	}

	/*
	 * (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService#existingUserWithPendingDataMismatch(UserProfile)
	 * This will cover all existing user scenarios that exist in evault before 12.4 March MVI Compliance release
	 */
	public VoidServiceResponse existingUserWithPendingDataMismatch(UserProfile userProfile) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		VoidServiceResponse response = new VoidServiceResponse();
		MviProperties mviProp = MviProperties.getInstance();

		if(!mviProp.getIsMviEnabled()) {
			ServiceFactory.createPatientService().updatePatientFacilities(StringUtils.lowerCase(userProfile.getUserName()));
			return response;
		}	

		PRPAIN201306UV02 searchRes = null;
		PatientServiceResponse patResponse = ServiceFactory.createPatientService().getPatientForUser(userProfile);
		Patient existingPatient = patResponse.getPatient();
		Patient vetPatient = null;
		Object searchReqXML = CreateMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile); 
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			return response;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);

		if(searchObj != null)
			searchRes = (PRPAIN201306UV02)searchObj;
		if(searchRes ==null) {
			LOG.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			return response;
		}
		String ICNFromMviResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			ICNFromMviResponse=getICNfromSearchResult(searchRes);
			if(ICNFromMviResponse == null) {
				// Don't do anything coz no ICN found in MVI response
				//Auditor.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED);
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED,ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				return response;
			}
			else {
				//JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
				String SSNFromMviResponse = null;
				PRPAIN201305UV02 searchXmlObj = null;
				try {
					PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
					searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
				}catch (Exception ex) {
					ex.printStackTrace();
					return response;
				}
				SSNFromMviResponse=getSSNfromSearchResult(searchXmlObj, searchRes);
				String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
				if(SSNFromMviResponse==null || !(numberOnlySsn.equals(SSNFromMviResponse))) {
					addInfo(response, "mvi.update.advanced.failure.response",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
					return response;
				}
				
				//Auditor.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED );
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				//JAZZ:17155 - During match handle different ICN coming from MVI
				if (existingPatient!=null && !existingPatient.getIcn().equals(ICNFromMviResponse) ) {
					patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientByIcn(ICNFromMviResponse);
					if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						LOG.info("During Login in the match process ICN from MVI: " + ICNFromMviResponse +
							" is different from evault.patient ICN: " + existingPatient.getIcn() + 
							" ICN from MVI belongs to another patient with user profile id: " + patResponse.getPatient().getUserProfile().getId());
						return response;
					} else {
						existingPatient.setIcn(ICNFromMviResponse); 
						gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().updatePatientRegistryInformation(existingPatient);
					}
				}
				
				if (existingPatient == null || existingPatient.getIcn().equals(ICNFromMviResponse) ) {
					if (existingPatient == null) {
						vetPatient = TransferObjectFactory.createPatient();
						vetPatient.setIcn(ICNFromMviResponse);
						vetPatient.setUserProfile(userProfile);
					}
					if (LOG.isDebugEnabled())
						LOG.debug("Existing Patients ICN Matched with MVI Response ICN OR Dealing with Existing Veteran");
					if (searchRes.getControlActProcess().getSubjectArray() != null ) {
						PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
						if(subjectSearchArray[0].getRegistrationEvent() != null) {
							PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
							II[] searchPatientIdArray = searchResultPatient.getIdArray();
							// Updating the facilities with the newer ones we received from MVI
							if (vetPatient == null)
								processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray), existingPatient, userProfile);
							else
								processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray), vetPatient, userProfile);
						}
					}
					if(vetPatient == null) {
						existingPatient.setCorrelationStatus(PatientCorrelationStatusUtils.MVI_DATA_MATCH);
						existingPatient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
						//ServiceFactory.createEntityMaintenanceService().save(existingPatient);

						// Now we will update the Authentication Status
						BooleanServiceResponse responseCorrelation = ServiceFactory.createMviAsyncIntegrationService().addPersonForCorrelation(existingPatient, userProfile, false);
						InPersonAuthenticationServiceResponse ipaResponse = ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(existingPatient.getId());
						InPersonAuthentication ipaPatient = ipaResponse.getInPersonAuthentication();
						if(ipaPatient != null && ipaPatient.getStatus().equals(AuthenticationStatus.getEnum(AuthenticationStatus.AUTHENTICATED))) {
							ipaPatient.setMviAuthenticationStatus("PENDING_AUTH");
							ipaPatient.setAuthenticationDate(new Timestamp(new Date().getTime()));
							ipaPatient.setAuthenticatedBy(ActivityActorTypeEnumeration.SYSTEM);
							ServiceFactory.createEntityMaintenanceService().save(ipaPatient);
							existingPatient.setPatientSynchronizations(null);
						}	
						if(ipaPatient != null && ipaPatient.getStatus().equals(AuthenticationStatus.getEnum(AuthenticationStatus.PENDINGDATAMISMATCH))) {
							ipaPatient.setStatus(AuthenticationStatus.getEnum(AuthenticationStatus.AUTHENTICATED));
							ipaPatient.setMviAuthenticationStatus("PENDING_AUTH");
							ipaPatient.setAuthenticationDate(new Timestamp(new Date().getTime()));
							ipaPatient.setAuthenticatedBy(ActivityActorTypeEnumeration.SYSTEM);
							ServiceFactory.createEntityMaintenanceService().save(ipaPatient);
						}
					}
					else {
						vetPatient.setCorrelationStatus(PatientCorrelationStatusUtils.MVI_DATA_MATCH);
						vetPatient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
						BooleanServiceResponse resp = addVetForCorrelation(vetPatient, userProfile);
						//if (resp.getBoolean().booleanValue())
						ServiceFactory.createEntityMaintenanceService().save(vetPatient);
					}
					Set facilitiesList = new HashSet();		
					if(vetPatient != null)
						facilitiesList = vetPatient.getFacilitys();
					else
						facilitiesList = existingPatient.getFacilitys();
					List<String> stationNumberArray = new ArrayList<String>();
					for (Object f: facilitiesList) {
						Facility facility = (Facility) f;
						stationNumberArray.add(facility.getName());
					}
					if(MviUtil.checkTreatmentFacilitiesExist(stationNumberArray))
						userProfile.setIsPatient(true);
					else {
						userProfile.setIsPatient(false);
						userProfile.setIsVeteran(true);
					}	
					userProfile.setIsMPIControlled(true);
					ServiceFactory.createEntityMaintenanceService().save(userProfile);
					
				}else{
					if (LOG.isInfoEnabled())
						LOG.info("Existing Patients ICN does not match MVI Response ICN. Existing ICN:" +existingPatient.getIcn() +". Received ICN: " +ICNFromMviResponse + " For User: "+existingPatient.getUserProfile().getId());
				}
			}
		}		
		else {
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Max Results Exceeded in MVI: "+queryResponseCode.getCode() + " for user profile id: " + userProfile.getId());
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(LOG.isErrorEnabled())
					LOG.error("Application Error in MVI: "+queryResponseCode.getCode()+ " for user profile id: " + userProfile.getId());
				addInfo(response, "mvi.parse.response.ae.issue",new String[]{MviConstants.BASIC_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.ADVANCED_URL, MviConstants.TARGET_NEW_WINDOW, MviConstants.CONTACTMHV_URL} );
				return response;
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				//Auditor.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED);
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED,ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				if(LOG.isErrorEnabled())
					LOG.error("User not found in MVI: "+queryResponseCode.getCode()+ " for user profile id: " + userProfile.getId());
			}

			return response;
		}

		return response;
	}

	private String getSSNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			PRPAMT201310UV02OtherIDs[] otherIds = patient.getPatientPerson().getAsOtherIDsArray();
			for (int i=0; i< otherIds.length; i++) {
				PRPAMT201310UV02OtherIDs otherId = otherIds[i];
				//JAZZ Defect # 29216 - MVI correlation issue - User with Alias SSN will not be matched or correlated- Fix:Made sure that the SSN is compared with equals instead of contains 
				if(otherId.getClassCode().equals("SSN")) {
					II idArray[] = otherId.getIdArray();
					for (int j=0; j< idArray.length; i++) {
						II id = idArray[j];
						return id.getExtension();
					}
				}
			}
		}
		else {
			LOG.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

    private InPersonAuthentication saveIPA(InPersonAuthentication ipa,
            AuthenticationStatus status) {
        InPersonAuthenticationBO bo = BusinessObjectFactory
            .createInPersonAuthenticationBO();
        ipa = bo.saveAndUpdateStatus(ipa, status);
        return ipa;
    }
    
	public BooleanServiceResponse mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch) {
		//return ServiceFactory.createMviIntegrationService().mviAuthenticate(patient, userProfile, authenticate, batch);
		InPersonAuthenticationServiceResponse ipaResponse = 
			ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(patient.getId());
		InPersonAuthentication ipa = ipaResponse.getInPersonAuthentication();
        AuthenticationStatus status = InPersonAuthenticationStatusUtils.AUTHENTICATED;
        ipa.setAuthenticationDate(new Timestamp(new Date().getTime()));
        ipa = saveIPA(ipa, status);
        
        BooleanServiceResponse patientServiceResponse = new BooleanServiceResponse();
        patientServiceResponse.setBoolean(false);
        
        if (!hasErrorMessages(ipaResponse)) {
			patientServiceResponse = ServiceFactory.createMviIntegrationService().mviAuthenticate(
				patient, patient.getUserProfile(), true, false);
            if (patientServiceResponse.getBoolean()) {
            	ipa.setMviAuthenticationStatus("OK");
                ipa = saveIPA(ipa, status);
            } else {
            	ipa.setMviAuthenticationStatus("PENDING_AUTH");
            	ipa = saveIPA(ipa, status);
            }
        }

        return patientServiceResponse; 
	}
	
	public BooleanServiceResponse mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName) {
		InPersonAuthenticationServiceResponse ipaResponse = 
			ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(patient.getId());
		InPersonAuthentication ipa = ipaResponse.getInPersonAuthentication();
        Precondition.assertNotNull("ipa", ipa);
        Precondition.assertNotNull("ipa.patient", ipa.getPatient());
        BooleanServiceResponse response = new BooleanServiceResponse();
        response.setBoolean(false);
        AuthenticationStatus status = InPersonAuthenticationStatusUtils.UNAUTHENTICATED;
        ipa.setParticipationFormSigned(Boolean.FALSE);
        ipa.setIdentificationPresented(Boolean.FALSE);
        ipa.setApprovedForRecordsAccess(Boolean.FALSE);
        ipa.setDefermentReason(null);
        ipa.setAuthenticatingFacility(null);
        ipa.setAuthenticationDate(null);
        ipa = saveIPA(ipa, status);

        //response.setInPersonAuthentication(ipa);
        copyMessages(response, ipa);
        if (!hasErrorMessages(response)) {
			//MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - If the MVI flag is turned on call, MVI call instead of MPI call
            BooleanServiceResponse patientServiceResponse = null;
			ipa.setMviAuthenticationStatus("PENDING_UNAUTH");
            if (!hasErrorMessages(response)) {
    			//MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - If the MVI flag is turned on call, MVI call instead of MPI call
				patientServiceResponse = ServiceFactory.
                createPatientService().mviUnauthenticate(ipa.getPatient());
                if (patientServiceResponse.getBoolean()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():SUCCESS unauthenticating patient with ICN:" + ipa.getPatient().getIcn());
                    }
        			//MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - If the patient status is correleated or pending corr/uncorr
                    //try to uncorrelate. Only 
                	if(ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.CORRELATED)||
                	   ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.PENDINGCORRELATION)||
                	   ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.PENDINGUNCORRELATION)) {
	                	PatientServiceResponse patientResponse = 
	        				ServiceFactory.createMviIntegrationService().deletePersonFromCorrelationForIPA(ipa.getPatient(), ipa.getPatient().getUserProfile(), "");
	        			if (patientResponse.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.MVIDATAMATCH)) {
	        				//Only when both unauthenticate and uncorrelate are successful, we set to OK flag
	        				ipa.setMviAuthenticationStatus("OK");
	                        if (LOG.isDebugEnabled()) {
	                            LOG.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():SUCCESS uncorrelating patient with ICN:" + ipa.getPatient().getIcn());
	                        }
	                        response.setBoolean(true);
	        			} else {
	                        if (LOG.isDebugEnabled()) {
	                            LOG.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():ERROR uncorrelating patient with ICN:" + ipa.getPatient().getIcn());
	                        }
	        			}
                	}
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():ERROR unauthenticating patient with ICN:" + ipa.getPatient().getIcn());
                    }

                }
            }
            ipa = saveIPA(ipa, status);
        }
        return response; 
	}
	
	/*
	 * 
	 */
	private BooleanServiceResponse addVetForCorrelation(Patient patient, UserProfile userProfile) {
		BooleanServiceResponse response = new BooleanServiceResponse();
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		Object correlationReqXML = CreateMVICorrelationRequest.createCorrelationXMLRequest(userProfile,patient); 
		//MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		patient.setCorrelateRequestDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);

		if(searchObj == null) {
			if (LOG.isErrorEnabled()) {
				LOG.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			response.setBoolean(false);
		}
		else {
			MCCIIN000002UV01 searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];  
			//}
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.CORRELATED);
				//Admin Portal_CodeCR1747 - Changed from SYSTEM to System
				patient.setCorrelatedBy("System");
				Auditor.auditMviEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				response.setBoolean(true);

			}
			else {
				patient.setCorrelationStatus(PatientCorrelationStatusUtils.FAILED_CORRELATION);
			}

		}

		return response;

	}

	private String getICNfromSearchResult(PRPAIN201306UV02 searchRes) {
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals("200M") && issuer.equals("USVHA")) {
					String patientICN = idExtn[0];
					return patientICN;
				}
			}	
		}
		return null;
	}

	private void processFacilityChanges(Map<String, Facility> receivedfacilityNames, Patient existingPatient, UserProfile userProfile) {
		Map<String, Facility> oldFacilities = collectStationNumbers(existingPatient);
		if (!CollectionUtils.isEqualCollection(receivedfacilityNames.keySet(),oldFacilities.keySet()))
		{
			PatientRegistryChange changeRec = getChangeRecord("Facilities", userProfile);
			changeRec.setOldFacilityCount(existingPatient.getFacilitys().size());
			existingPatient.addPatientRegistryChange(changeRec);
			Set<Facility> facilities = new HashSet<Facility>();
			for (String stationNumber: receivedfacilityNames.keySet()) {
				Facility facility = oldFacilities.get(stationNumber);
				if (facility == null) {
					if (LOG.isDebugEnabled()) {
						LOG.debug("Adding facility in evault from MVI " + stationNumber
								+ "'");
					}
					facility = receivedfacilityNames.get(stationNumber);
				} else {
					if (LOG.isDebugEnabled()) {
						LOG.debug("Keeping facility exists in evault'" + stationNumber +
								"' (" + facility.getId() + ")");
					}
				}
				facilities.add(facility);
			}
			if (LOG.isDebugEnabled()) {
				for (String stationNumber: oldFacilities.keySet()) {
					Facility facility = receivedfacilityNames.get(stationNumber);
					if (facility == null) {
						LOG.debug("Removing facilities from evault with respect to the MVI response '" + stationNumber
								+ "'");
					}
				}
			}
			existingPatient.setFacilitys(facilities);
		}
	}

	private Map<String, Facility> collectStationNumbers(Patient patient) {
		assert patient != null : "Must provide a patient";
		Map<String, Facility> facilityNames =
			new HashMap<String, Facility>();
		for (Object f: patient.getFacilitys()) {
			Facility facility = (Facility) f;
			facilityNames.put(facility.getName(), facility);
		}
		return facilityNames;
	}

	public Map<String, Facility> receivedFacilitiesFromMvi(II[]searchPatientIdArray) {
		Map<String, Facility> receivedfacilityNames = new HashMap<String, Facility>();
		for (int i=0; i< searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("PI") || searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String stationNumber = idExtn[2];
				String facilityStatus = idExtn[4];
				if(facilityStatus.equalsIgnoreCase("A")) {
					if(!StringUtils.isBlank(stationNumber) ) {
						Facility facility = TransferObjectFactory.createFacility();
						facility.setName(stationNumber);
						receivedfacilityNames.put(stationNumber, facility);
						receivedfacilityNames.put(facility.getName(), facility);
					}	
				}
			}
		}
		return receivedfacilityNames;
	}
	private PatientRegistryChange getChangeRecord(String forProperty, UserProfile userProfile) {
		if (LOG.isDebugEnabled()) {
			LOG.debug("found " + forProperty + " change for "
					+ userProfile.getUserName());
		}

		PatientRegistryChange changeRecord = TransferObjectFactory.createPatientRegistryChange();
		changeRecord.setRecordedOnDate(TimestampUtils.createCurrentTime());

		return changeRecord;
	}

}	